/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CDialog.cpp,v 1.1 1999/09/12 04:29:44 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CDialog.h"
#include "CRect.h"
#include "UModuleInstance.h"

_USING_PGP

// Class CDialog member functions

PGPInt32 
CDialog::CreateModal(HWND parent)
{
	pgpAssert(!WeCreated());
	pgpAssert(!WeSubclassed());

	PGPInt32	result;

	mIsModal = TRUE;

	result	= DialogBoxParam(UModuleInstance::Get(), 
		MAKEINTRESOURCE(GetDialogId()), parent, GlobalDialogProc, 
		reinterpret_cast<LPARAM>(this));

	if (result == -1)
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());

	if (result == IDCANCEL)
		THROW_PGPERROR(kPGPError_UserAbort);
	else if (result == IDDialogError)
		throw mError;

	return result;
}

void 
CDialog::CreateNonModal(HWND parent)
{
	pgpAssert(!WeCreated());
	pgpAssert(!WeSubclassed());

	mIsModal = FALSE;

	HWND	hWnd	= CreateDialogParam(UModuleInstance::Get(), 
		MAKEINTRESOURCE(GetDialogId()), parent, GlobalDialogProc, 
		reinterpret_cast<LPARAM>(this));

	if (IsNull(hWnd))
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());
}

void 
CDialog::DestroyDialog()
{
	pgpAssert(WeCreated());
	pgpAssert(IsWindow(Handle()));

	if (!::DestroyWindow(Handle()))
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());
}

void 
CDialog::RectPixelToDLU(RECT& rect) const
{
	rect.left	= HorizPixelToDLU(rect.left);
	rect.top	= VertPixelToDLU(rect.top);
	rect.right	= HorizPixelToDLU(rect.right);
	rect.bottom	= VertPixelToDLU(rect.bottom);
}

void 
CDialog::RectDLUToPixel(RECT& rect) const
{
	rect.left	= HorizDLUToPixel(rect.left);
	rect.top	= VertDLUToPixel(rect.top);
	rect.right	= HorizDLUToPixel(rect.right);
	rect.bottom	= VertDLUToPixel(rect.bottom);
}

void 
CDialog::CreateAsPropPage(PROPSHEETPAGE& psp, HPROPSHEETPAGE& pageHandle)
{
	mIsModal = TRUE;

	psp.hInstance	= UModuleInstance::Get();
	psp.pszTemplate	= MAKEINTRESOURCE(GetDialogId());
	psp.pfnDlgProc	= PropPageStub;
	psp.lParam		= reinterpret_cast<LPARAM>(this);

	pageHandle = CreatePropertySheetPage(&psp);

	if (IsNull(pageHandle))
		THROW_PGPERROR(kPGPError_Win32CommCtrlOpFailed);
}

void 
CDialog::EndModalDialog(PGPInt32 result)
{
	pgpAssert(WeSubclassed());
	::EndDialog(Handle(), result);
}

void 
CDialog::EndModalDialog(CComboError error)
{
	pgpAssert(WeSubclassed());

	mError = error;
	::EndDialog(Handle(), IDDialogError);
}

void 
CDialog::EndNonModalDialog()
{
	pgpAssert(WeSubclassed());
	DestroyWindow();
}

void 
CDialog::CalcBaseUnits()
{
	CRect	rc(0, 0, 4, 8);
	MapDialogRect(rc);
	
	mBaseUnitX = rc.Right();
	mBaseUnitY = rc.Bottom();
}

void 
CDialog::HandleWindowError(CComboError error)
{
	if (mIsModal)
		EndModalDialog(error);
	else
		CWindow::HandleWindowError(error);
}

BOOL 
CALLBACK 
CDialog::GlobalDialogProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	try
	{
		if (uMsg == WM_INITDIALOG)
		{
			// New dialog created, subclass window procedure.
			CDialog	*pDialog	= reinterpret_cast<CDialog *>(lParam);

			pgpAssertAddrValid(pDialog, CDialog);
			pDialog->Subclass(hWnd);

			// Handle InitDialog.
			try
			{
				return pDialog->OnInitDialog(reinterpret_cast<HWND>(wParam));
			}
			catch (CComboError& error)
			{
				pDialog->HandleWindowError(error);
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	catch (CComboError&)
	{
		pgpAssert(FALSE);
		return FALSE;
	}
}

BOOL 
CALLBACK 
CDialog::PropPageStub(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if (uMsg == WM_INITDIALOG)
	{
		return GlobalDialogProc(hWnd, uMsg, wParam, 
			reinterpret_cast<PROPSHEETPAGE *>(lParam)->lParam);
	}

	return FALSE;
}

void 
CDialog::OnCancel()
{
	if (mIsModal)
		EndModalDialog(IDCANCEL);
	else
		EndNonModalDialog();
}

void 
CDialog::OnOk()		
{
	if (mIsModal)
		EndModalDialog(IDOK);
	else
		EndNonModalDialog();
}

BOOL 
CDialog::OnCommand(PGPUInt16 notifyCode, PGPUInt16 itemId, HWND ctrl)
{
	if (notifyCode == BN_CLICKED)
	{
		switch (itemId)
		{
		case IDOK:
			OnOk();
			return TRUE;

		case IDCANCEL:
			OnCancel();
			return TRUE;
		}
	}

	return CWindow::OnCommand(notifyCode, itemId, ctrl);
}

BOOL 
CDialog::OnInitDialog(HWND focusCtrl)
{
	CalcBaseUnits();
	return CallDefault();
}
